#!/bin/bash
# Assign local IP to SPARK_ENV_PATH
# Grab the interface IP. Note, this assumes there is
# one external interface and it has an mtu of 1500
# If this is not the case, this sccript may nont work.
. /etc/profile.d/spark.sh;
. /etc/profile.d/java.sh;
. /etc/profile.d/hadoop.sh;

SPARK_ENV_PATH="$SPARK_HOME/conf/"
IP=$(ifconfig|grep -A1 "mtu 1500" |grep broadcast|awk '{print $2}')
if !  [[ $IP =~ ^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$ ]]; then
  echo "SPARK HISTORY bad local IP: $IP"
  echo "No Change to SPARK_LOCAL_IP"
else
  sed -i s!SPARK_LOCAL_IP=.*!SPARK_LOCAL_IP=$IP! $SPARK_ENV_PATH/spark-env.sh
  echo "SPARK_LOCAL_IP is set to $IP"
fi
# Make sure /tmp/spark-events is available
mkdir -p /tmp/spark-events
chown spark:hadoop /tmp/spark-events/
chmod ug+rwx /tmp/spark-events/
echo "STARTING SPARK HISTORY";
$SPARK_HOME//sbin/start-history-server.sh
echo 'COMPLETE';
