#!/bin/bash
. /etc/profile.d/nifi.sh; 
. /etc/profile.d/java.sh; 

echo 'Starting Nifi';
# To work in the LHM VM, Nifi needs the real IP number assigned
# by the VirtualBox DHCP service in nifi.properties (assumes device enp0s3). 

# Grab the IP, and place it in nifi.properties, if empty or not valid, use 12.0.0.1
# Note assumes enp0s3 and specific paths

IFACE="enp0s3"
NIFIPROPERTIES="/opt/nifi-1.15.3/conf/nifi.properties"
NIFIBOOTSTRAPLOG="/var/log/nifi/nifi-bootstrap.log"

IPNUM=$(ifconfig $IFACE|grep netmask|gawk '{print $2}')
if [ "$IPNUM" != "" ];then
  # quick check to see if it is valid format
  if ! [[ "$IPNUM" =~ ^(([1-9]?[0-9]|1[0-9][0-9]|2([0-4][0-9]|5[0-5]))\.){3}([1-9]?[0-9]|1[0-9][0-9]|2([0-4][0-9]|5[0-5]))$ ]]; then
    IPNUM="127.0.0.1"
  fi
else
    IPNUM="127.0.0.1"
fi
echo ">>>> LHM Using $IPNUM for NiFi IP <<<<" >> $NIFIBOOTSTRAPLOG
sed "s!_LHM_IP_ADDRESS_!$IPNUM!" /opt/nifi-1.15.3/conf/nifi.properties.template  >$NIFIPROPERTIES

# now ready to start

$NIFI_HOME/bin/nifi.sh start
echo 'COMPLETE';

