#!/bin/bash
# change HADOOP_PATH as needed
HADOOP_PATH=/opt/hadoop-3.3.6
FILES_PATH=../files
# add users
groupadd hadoop
useradd -g hadoop yarn
useradd -g hadoop hdfs
useradd -g hadoop mapred
useradd -g hadoop hands-on
# These are for data storage (owned by user hdfs)
mkdir -p /var/data/hadoop/hdfs/nn
mkdir -p /var/data/hadoop/hdfs/snn
mkdir -p /var/data/hadoop/hdfs/dn
chown hdfs:hadoop /var/data/hadoop/hdfs -R
#  Create the log directory and set the owner and group
mkdir /var/log/hadoop
chown yarn:hadoop /var/log/hadoop/
chmod ug+rwx /var/log/hadoop
# copy configuration files
LIST="core-site.xml hdfs-site.xml log4j.properties mapred-env.sh mapred-site.xml hadoop-env.sh yarn-env.sh yarn-site.xml"
for I in $LIST; do
  /bin/cp $HADOOP_PATH/etc/hadoop/$I $HADOOP_PATH/etc/hadoop/$I.orig
  /bin/cp $FILES_PATH/$I $HADOOP_PATH/etc/hadoop/$I
done
chown -R yarn:hadoop $HADOOP_PATH

# Systemd configuration
mkdir -p /opt/services
cp start-hdfs.sh /opt/services                 
cp stop-hdfs.sh /opt/services  
cp start-yarn.sh /opt/services                 
cp stop-yarn.sh /opt/services  
cp startup-hadoop-services /opt/services       
cp shutdown-hadoop-services /opt/services    
chmod 744 /opt/services/*

cp $FILES_PATH/hadoop.service /etc/systemd/system
chmod 644 /etc/systemd/system/hadoop.service

# systemd command to enable hadoop service startup
systemctl enable hadoop.service


echo "Complete"

